import scipy.io as sio
import numpy as np
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 22})


dx=0.05
dz=0.025

ni=34
nj=49
nk=34


viscos=1./8000.

#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_1 & transform v_1 to a 3D array (file 1)
uvw = sio.loadmat('u1_sdes.mat')
ttu=uvw['u1_sdes']
u3d1= np.reshape(ttu,(nk,nj,ni))
# N.B.- We don't have to swich axex since python and fortran stores an array in the same way

uvw = sio.loadmat('v1_sdes.mat')
tt=uvw['v1_sdes']
v3d1= np.reshape(tt,(nk,nj,ni))

uvw = sio.loadmat('w1_sdes.mat')
tt=uvw['w1_sdes']
w3d1= np.reshape(tt,(nk,nj,ni))

# read modelled turbulent kinetic energy (file 1)
uvw = sio.loadmat('te1_sdes.mat')
tt=uvw['te1_sdes']
te3d1= np.reshape(tt,(nk,nj,ni))  

# read modelled turbulent dissipation (file 1)
uvw = sio.loadmat('om1_sdes.mat')  # omega
tt=uvw['om1_sdes']
om3d1= np.reshape(tt,(nk,nj,ni))

# merge 2 files. This means that new ni = 2*ni
#u3d=np.concatenate((u3d1, u3d2), axis=0)
#v3d=np.concatenate((v3d1, v3d2), axis=0)
#w3d=np.concatenate((w3d1, w3d2), axis=0)


u3d = u3d1
v3d = v3d1
w3d = w3d1
te3d = te3d1
om3d = om3d1


# x coordinate direction = index 0, first index
# y coordinate direction = index 1, second index
# z coordinate direction = index 2, third index



ni=len(u3d)

x=dx*ni
z=dz*nk


umean=np.mean(u3d, axis=(0,2))
vmean=np.mean(v3d, axis=(0,2))
wmean=np.mean(w3d, axis=(0,2))
temean=np.mean(te3d, axis=(0,2))
ommean=np.mean(om3d, axis=(0,2))

# face coordinates
yc = np.loadtxt("yc.dat")

# cell cener coordinates
y= np.zeros(nj)
dy=np.zeros(nj)
for j in range (1,nj-1):
# dy = cell width
   dy[j]=yc[j]-yc[j-1]
   y[j]=0.5*(yc[j]+yc[j-1])

y[nj-1]=yc[nj-1]
tauw=viscos*umean[1]/y[1]
ustar=tauw**0.5
yplus=y*ustar/viscos



DNS=np.genfromtxt("LM_Channel_5200_mean_prof.dat", dtype=None,comments="%")
y_DNS=DNS[:,0]
yplus_DNS=DNS[:,1]
u_DNS=DNS[:,2]


DNS=np.genfromtxt("LM_Channel_5200_vel_fluc_prof.dat", dtype=None,comments="%")

u2_DNS=DNS[:,2]
v2_DNS=DNS[:,3]
w2_DNS=DNS[:,4]
uv_DNS=DNS[:,5]

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)

# find equi.distant DNS cells in log-scale
xx=0.
jDNS=[1]*40
for i in range (0,40):
   i1 = (np.abs(10.**xx-yplus_DNS)).argmin()
   jDNS[i]=int(i1)
   xx=xx+0.2

fig1 = plt.figure("Figure 1")

plt.semilogx(yplus,umean/ustar,'b-')
plt.semilogx(yplus_DNS[jDNS],u_DNS[jDNS],'bo')
plt.axis([1, 8000, 0, 31])
plt.ylabel("$U^+$")
plt.xlabel("$y^+")

plt.savefig('u_log_zonal_sdes_python.eps',bbox_inches='tight')

