close all
clear all


dx=0.05;
dz=0.025;

ni=34;
nj=49;
nk=34;

viscos=1/8000;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_1 & transform v_1 to a 3D array (file 1)
load u1_sdes.mat
u1=u1_sdes;
u3d1=reshape(u1,ni,nj,nk);

load v1_sdes.mat
v1=v1_sdes;
v3d1=reshape(v1,ni,nj,nk);

load w1_sdes.mat
w1=w1_sdes;
w3d1=reshape(w1,ni,nj,nk);

% read modelled turbulent kinetic energy (file 1)
load te1_sdes.mat
te1=te1_sdes;
te3d1=reshape(te1,ni,nj,nk);

% read modelled turbulent dissipation (file 1)
load om1_sdes.mat
om1=om1_sdes;
om3d1=reshape(om1,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_2 & transform v_2 to a 3D array (file 2)
load u2_sdes.mat
u2=u2_sdes;
u3d2=reshape(u2,ni,nj,nk);

load v2_sdes.mat
v2=v2_sdes;
v3d2=reshape(v2,ni,nj,nk);

load w2_sdes.mat
w2=w2_sdes;
w3d2=reshape(w2,ni,nj,nk);

% read modelled turbulent kinetic energy (file 2)
load te2_sdes.mat
te2=te2_sdes;
te3d2=reshape(te2,ni,nj,nk);

% read modelled turbulent dissipation (file 2)
load om2_sdes.mat
om2=om2_sdes;
om3d2=reshape(om2,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_3 & transform v_3 to a 3D array (file 3)
load u3_sdes.mat
u3=u3_sdes;
u3d3=reshape(u3,ni,nj,nk);

load v3_sdes.mat
v3=v3_sdes;
v3d3=reshape(v3,ni,nj,nk);

load w3_sdes.mat
w3=w3_sdes;
w3d3=reshape(w3,ni,nj,nk);

% read modelled turbulent kinetic energy (file 3)
load te3_sdes.mat
te3=te3_sdes;
te3d3=reshape(te3,ni,nj,nk);

% read modelled turbulent dissipation (file 3)
load om3_sdes.mat
om3=om3_sdes;
om3d3=reshape(om3,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_4 & transform v_4 to a 3D array (file 4)
load u4_sdes.mat
u4=u4_sdes;
u3d4=reshape(u4,ni,nj,nk);

load v4_sdes.mat
v4=v4_sdes;
v3d4=reshape(v4,ni,nj,nk);

load w4_sdes.mat
w4=w4_sdes;
w3d4=reshape(w4,ni,nj,nk);

% read modelled turbulent kinetic energy (file 4)
load te4_sdes.mat
te4=te4_sdes;
te3d4=reshape(te4,ni,nj,nk);

% read modelled turbulent dissipation (file 4)
load om4_sdes.mat
om4=om4_sdes;
om3d4=reshape(om4,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_5 & transform v_5 to a 3D array (file 5)
load u5_sdes.mat
u5=u5_sdes;
u3d5=reshape(u5,ni,nj,nk);

load v5_sdes.mat
v5=v5_sdes;
v3d5=reshape(v5,ni,nj,nk);

load w5_sdes.mat
w5=w5_sdes;
w3d5=reshape(w5,ni,nj,nk);

% read modelled turbulent kinetic energy (file 5)
load te5_sdes.mat
te5=te5_sdes;
te3d5=reshape(te5,ni,nj,nk);

% read modelled turbulent dissipation (file 5)
load om5_sdes.mat
om5=om5_sdes;
om3d5=reshape(om5,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_6 & transform v_6 to a 3D array (file 6)
load u6_sdes.mat
u6=u6_sdes;
u3d6=reshape(u6,ni,nj,nk);

load v6_sdes.mat
v6=v6_sdes;
v3d6=reshape(v6,ni,nj,nk);

load w6_sdes.mat
w6=w6_sdes;
w3d6=reshape(w6,ni,nj,nk);

% read modelled turbulent kinetic energy (file 6)
load te6_sdes.mat
te6=te6_sdes;
te3d6=reshape(te6,ni,nj,nk);

% read modelled turbulent dissipation (file 6)
load om6_sdes.mat
om6=om6_sdes;
om3d6=reshape(om6,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_7 & transform v_7 to a 3D array (file 7)
load u7_sdes.mat
u7=u7_sdes;
u3d7=reshape(u7,ni,nj,nk);

load v7_sdes.mat
v7=v7_sdes;
v3d7=reshape(v7,ni,nj,nk);

load w7_sdes.mat
w7=w7_sdes;
w3d7=reshape(w7,ni,nj,nk);

% read modelled turbulent kinetic energy (file 7)
load te7_sdes.mat
te7=te7_sdes;
te3d7=reshape(te7,ni,nj,nk);

% read modelled turbulent dissipation (file 7)
load om7_sdes.mat
om7=om7_sdes;
om3d7=reshape(om7,ni,nj,nk);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  read v_8 & transform v_8 to a 3D array (file 8)
load u8_sdes.mat
u8=u8_sdes;
u3d8=reshape(u8,ni,nj,nk);

load v8_sdes.mat
v8=v8_sdes;
v3d8=reshape(v8,ni,nj,nk);

load w8_sdes.mat
w8=w8_sdes;
w3d8=reshape(w8,ni,nj,nk);

% read modelled turbulent kinetic energy (file 8)
load te8_sdes.mat
te8=te8_sdes;
te3d8=reshape(te8,ni,nj,nk);

% read modelled turbulent dissipation (file 8)
load om8_sdes.mat
om8=om8_sdes;
om3d8=reshape(om8,ni,nj,nk);

% merge files
u3d = vertcat(u3d1,u3d2,u3d3,u3d4,u3d5,u3d6,u3d7,u3d8);
v3d = vertcat(v3d1,v3d2,v3d3,v3d4,v3d5,v3d6,v3d7,v3d8);
w3d = vertcat(w3d1,w3d2,w3d3,w3d4,w3d5,w3d6,w3d7,w3d8);
te3d = vertcat(te3d1,te3d2,te3d3,te3d4,te3d5,te3d6,te3d7,te3d8);
om3d = vertcat(om3d1,om3d2,om3d3,om3d4,om3d5,om3d6,om3d7,om3d8);

%8 files (34x49x34)  of instantaneous data have been merged;  the new size of the arrays is 8*34x49x34
ni=size(u3d,1);

% x coordinate direction = index i, first index
% y coordinate direction = index j, second index
% z coordinate direction = index k, third index


% average in 1st (x) and 3rd (z) direction
umean=mean(mean(u3d,3),1);
vmean=mean(mean(v3d,3),1);
wmean=mean(mean(w3d,3),1);
temean=mean(mean(te3d,3),1);
ommean=mean(mean(om3d,3),1);


% face coordinates
load yc.dat

y_zonal_sdes(1)=0; % node coordinates
for j=2:nj
% dy = cell width
   dy(j)=yc(j)-yc(j-1);
   y(j)=0.5*(yc(j)+yc(j-1));
end
dy(nj)=0;

tauw=viscos*umean(2)/y(2);
ustar=tauw^0.5;
yplus=y*ustar/viscos;;

load LM_Channel_5200_mean_prof.dat
y_DNS=LM_Channel_5200_mean_prof(:,1);
yplus_DNS=LM_Channel_5200_mean_prof(:,2);
u_DNS=LM_Channel_5200_mean_prof(:,3);

load LM_Channel_5200_vel_fluc_prof.dat
u2_DNS=LM_Channel_5200_vel_fluc_prof(:,3);
v2_DNS=LM_Channel_5200_vel_fluc_prof(:,4);
w2_DNS=LM_Channel_5200_vel_fluc_prof(:,5);
uv_DNS=LM_Channel_5200_vel_fluc_prof(:,6);

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS);

% find equi.distant DNS cells in log-scale
xx=0;
for i=1:40
   ii = find(yplus_DNS < 10^xx);
   i1=ii(end);
   jDNS(i)=i1;
   xx=xx+0.2;
end


% T.2.
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
figure(1)
% plot u log
plot(yplus,umean/ustar,'linewidth',2)
hold
h1=plot(yplus_DNS(jDNS),u_DNS(jDNS),'bo','linewidth',2)
set(h1,'MarkerFaceColor','white')
axis([1 8000 0 31])
handle=gca;
set(handle,'fontsize',[20])
set(handle,'xscale','log')
xlabel('y^+','fontsize',[20])
ylabel('U^+','fontsize',[20])
print u_log_zonal_sdes.ps  -depsc

